<?php

namespace Inside\Events;

use Illuminate\Broadcasting\PendingBroadcast;

trait Dispatchable
{
    /**
     * dispatch event
     *
     * @return array|null
     */
    public static function dispatch(): ?array
    {
        return event(new static(...func_get_args()));
    }

    /**
     * dispatch event IF $boolean
     *
     * @param bool $boolean
     * @param mixed ...$arguments
     * @return array|null
     */
    public static function dispatchIf(bool $boolean, ...$arguments): ?array
    {
        if ($boolean) {
            return event(new static(...$arguments));
        }

        return null;
    }

    /**
     * dispatch unless $boolean
     *
     * @param bool $boolean
     * @param mixed ...$arguments
     * @return array|null
     */
    public static function dispatchUnless(bool $boolean, ...$arguments): ?array
    {
        if (! $boolean) {
            return event(new static(...$arguments));
        }

        return null;
    }

    /**
     * broadcast
     *
     * @return PendingBroadcast
     */
    public static function broadcast(): PendingBroadcast
    {
        return broadcast(new static(...func_get_args()));
    }
}
