<?php

namespace Inside;

use Illuminate\Contracts\Support\Arrayable;
use Illuminate\Contracts\Support\Jsonable;
use Inside\Support\AgentDetect;
use UAParser\Parser;
use UAParser\Result\Client;

class DeviceInformation implements Arrayable, Jsonable
{
    /**
     * @var null|Client
     */
    protected $uaParser;

    /**
     * @var AgentDetect
     */
    protected $agentDetect;

    public function __construct()
    {
        try {
            $this->uaParser = Parser::create()->parse($_SERVER['HTTP_USER_AGENT']);
        } catch (\Exception $exception) {
            $this->uaParser = null;
        }
        $this->agentDetect = new AgentDetect();
    }

    public function toArray(): array
    {
        return [
            'agent'            => $this->uaParser !== null ? (array) $this->uaParser->ua : 'unkown',
            'type'             => $this->agentDetect->detectDevice(),
            'device'           => $this->uaParser !== null ? (array) $this->uaParser->device : [],
            'operating_system' => $this->uaParser !== null ? $this->uaParser->os : 'unkown',
        ];
    }

    /**
     * @param int $options
     * @return false|string
     */
    public function toJson($options = 0)
    {
        return json_encode($this->toArray(), $options);
    }
}
