<?php

namespace Inside\Database;

use Illuminate\Database\MySqlConnection as BaseMySqlConnection;
use Illuminate\Filesystem\Filesystem;
use Inside\Database\Schema\MySqlSchemaState;
use PDO;

/**
 * Class MysqlConnection
 */
class MysqlConnection extends BaseMySqlConnection
{
    /**
     * @return bool
     */
    public function isMaria(): bool
    {
        return str_contains($this->getPdo()->getAttribute(PDO::ATTR_SERVER_VERSION), 'MariaDB');
    }

    /**
     * @param  Filesystem|null $files
     * @param callable|null                          $processFactory
     * @return MySqlSchemaState
     */
    public function getSchemaState(Filesystem $files = null, callable $processFactory = null): MySqlSchemaState
    {
        return new MySqlSchemaState($this, $files, $processFactory);
    }
}
