<?php

namespace Inside\Database\Eloquent\Factories;

use Inside\Database\Eloquent\Factories\Factory;

trait HasFactory
{
    /**
     * Get a new factory instance for the model.
     *
     * @param mixed $parameters
     * @return Factory
     */
    public static function factory(...$parameters): Factory
    {
        $factory = static::newFactory() ?: Factory::factoryForModel(get_called_class());

        return $factory->count(is_numeric($parameters[0] ?? null) ? $parameters[0] : null)->state(
            is_array($parameters[0] ?? null) ? $parameters[0] : ($parameters[1] ?? [])
        );
    }

    /**
     * Create a new factory instance for the model.
     *
     * @return Factory|null
     */
    protected static function newFactory()
    {
        //
    }
}
