<?php

namespace Inside\Database\Eloquent\Factories;

use Closure;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\MorphTo;

class BelongsToRelationship
{
    /**
     * The cached, resolved parent instance ID.
     */
    protected mixed $resolved;

    /**
     * Create a new "belongs to" relationship definition.
     */
    public function __construct(
        protected Factory|Model $factory,
        protected string $relationship
    ) {
    }

    /**
     * Get the parent model attributes and resolvers for the given child model.
     *
     * @param  Model  $model
     * @return array
     */
    public function attributesFor(Model $model): array
    {
        $relationship = $model->{$this->relationship}();

        return $relationship instanceof MorphTo
            ? [
                $relationship->getMorphType() => $this->factory instanceof Factory ? $this->factory->newModel()
                    ->getMorphClass()
                    : $this->factory->getMorphClass(),
                $relationship->getForeignKeyName() => $this->resolver($relationship->getOwnerKeyName()),
            ]
            : [
                $relationship->getForeignKeyName() => $this->resolver($relationship->getOwnerKeyName()),
            ];
    }

    /**
     * Get the deferred resolver for this relationship's parent ID.
     */
    protected function resolver(?string $key): Closure
    {
        return function () use ($key) {
            if (! $this->resolved) {
                $instance = $this->factory instanceof Factory ? $this->factory->create() : $this->factory;

                return $this->resolved = $key ? $instance->{$key} : $instance->getKey();
            }

            return $this->resolved;
        };
    }
}
