<?php

namespace Inside\Database\Eloquent\Factories;

use Closure;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Collection;

class BelongsToManyRelationship
{
    /** @var array|callable */
    protected mixed $pivot;

    public function __construct(
        protected Model|Factory|Collection $factory,
        callable|array $pivot,
        protected string $relationship
    ) {
        $this->pivot = $pivot;
    }

    /**
     * Create the attached relationship for the given model.
     *
     * @param Model $model
     * @return void
     */
    public function createFor(Model $model): void
    {
        Collection::wrap($this->factory instanceof Factory ? $this->factory->create([], $model) : $this->factory)->each(
            function ($attachable) use ($model) {
                $model->{$this->relationship}()->attach(
                    $attachable,
                    is_callable($this->pivot) ? call_user_func($this->pivot, $model) : $this->pivot
                );
            }
        );
    }
}
