<?php

namespace Inside\Contracts;

interface HasAbilities
{
    /**
     * Determine if object has ability to
     *
     * @param string $ability
     * @return bool
     */
    public function can($ability);

    /**
     * Determine if object is missing a given ability.
     *
     * @param string $ability
     * @return bool
     */
    public function cant($ability);
}
