<?php

namespace Inside\Console\Commands;

use Inside\Console\Command;
use Inside\Settings\Facades\Settings;
use Symfony\Component\Console\Formatter\OutputFormatterStyle;
use Symfony\Component\Yaml\Yaml;

/**
 * Class Version
 */
class Version extends Command
{
    protected $signature = 'version';

    protected $description = 'Get inside version';

    public function handle(): void
    {
        $style = new OutputFormatterStyle('yellow', 'blue', []);
        $this->output->getFormatter()->setStyle('blue', $style);

        $version = json_decode(setting('system', 'version', '{}'));
        if (! isset($version->major) || ! isset($version->minor) || ! isset($version->patch)) {
            $version = \Inside\Facades\Version::get();
            setting('system', ['version' => json_encode($version)]);
            $version = json_decode(setting('system', 'version', '{}'));
        }
        $this->output->writeln(
            '<blue> '.$version->major.'.'.$version->minor.'.'.$version->patch.' </blue>'
        );
        $this->line('');
    }
}
