<?php

namespace Inside\Console\Commands;

use Exception;
use Inside\Console\Command;
use Inside\Events\InsideIsGoingUp;

class UpCommand extends Command
{
    protected $name = 'inside:up';

    protected $description = 'Sortir le site du mode maintenance';

    public function handle(): int
    {
        try {
            if (! file_exists(storage_path('framework/inside_down'))) {
                $this->comment('Inside est déjà actif.');

                return Command::SUCCESS;
            }
            InsideIsGoingUp::dispatch();

            unlink(storage_path('framework/inside_down'));

            $this->info('Inside est réactivé.');

            return Command::SUCCESS;
        } catch (Exception $e) {
            $this->error('Echec de la sortie du mode maintenance.');

            $this->error($e->getMessage());

            return Command::FAILURE;
        }
    }
}
