<?php

namespace Inside\Console\Commands;

class RefreshCommand extends InstallationTools
{
    protected $name = 'inside:refresh';

    public function handle(): void
    {
        if (! $this->insideIsInstalled()) {
            $this->comment('Inside est n\' pas encore installé et n\'a donc rien a refresh');
            $this->warn(str_repeat('#', 80));

            return;
        }
        $this->rebuildIdeHelpers();
        $this->call('cache:clear', ['store' => 'file']);
    }
}
