<?php

namespace Inside\Console\Commands;

use Inside\Console\Command;

class PublicLinkCommand extends Command
{
    protected $signature = 'public:link';

    protected $description = 'Create a symbolic link to the public directory';

    public function handle(): void
    {
        $links = collect([
            cms_public_path('core') => cms_base_path('core'),
            cms_public_path('modules') => cms_base_path('modules'),
            cms_public_path('sites') => cms_base_path('sites'),
            cms_public_path('storage') => cms_base_path('storage'),
            cms_public_path('themes') => cms_base_path('themes'),
            cms_public_path('assets') => cms_base_path('assets'),
            cms_base_path('menus') => storage_path('app/menus'),
            cms_public_path('menus') => cms_base_path('menus'),
            cms_public_path('vendor/maecia') => cms_base_path('vendor/maecia'),
        ]);

        if (! file_exists(cms_public_path())) {
            $this->laravel->make('files')->makeDirectory(cms_public_path());
            $this->info('The [public] directory has been created.');
        }

        if (! file_exists(cms_public_path('vendor'))) {
            $this->laravel->make('files')->makeDirectory(cms_public_path('vendor'));
            $this->info('The [public/vendor] directory has been created.');
        }

        $links->each(function ($origin, $symlink) {
            if (! file_exists($symlink)) {
                $this->laravel->make('files')->link($origin, $symlink);
                $this->info("The [{$symlink}] directory has been linked.");
            } else {
                $this->info("The [{$symlink}] directory already exists.");
            }
        });
    }
}
