<?php

namespace Inside\Console\Commands;

use Inside\Console\Command;
use Inside\Facades\Package;

class PackageInfoCommand extends Command
{
    protected $signature = 'inside:package:info {package}';

    protected $description = 'Les informations d\'un package inside';

    public function handle(): void
    {
        /** @var string $name */
        $name = $this->argument('package');
        $packageInfo = Package::get($name);
        if ($packageInfo === null) {
            $this->error('Package ['.$name.'] is not installed');

            return;
        }
        $info = [];
        foreach ($packageInfo->toArray() as $key => $value) {
            if (is_bool($value)) {
                $value = $value ? 'oui' : 'non';
            } elseif (is_array($value)) {
                if (empty($value)) {
                    $value = '[]';
                } else {
                    $value = '['.implode("\n", (array) $value).']';
                }
            }
            $info[] = [$key, $value];
        }
        $this->table(
            ['Nom', 'Valeur'],
            $info
        );
    }
}
