<?php

namespace Inside\Console\Commands;

use Symfony\Component\Console\Formatter\OutputFormatterStyle;

class InstallCommand extends InstallationTools
{
    protected $name = 'inside:install';

    protected $description = 'Commande qui termine l\'installation : à lancer à la fin du composer install';

    public function handle(): void
    {
        $this->line("Vérification du status d'installation d'inside");
        if ($this->insideIsInstalled()) {
            $this->comment('Inside est déjà installé');
            $this->error('Utilisez plutôt php artisan inside:update');

            return;
        }
        $outputStyle = new OutputFormatterStyle('black', 'green');
        $this->output->getFormatter()->setStyle('inside', $outputStyle);
        $this->output->writeln('<inside>Début de l\'installation d\'Inside</inside>');

        $this->removeUnnecessaryFiles();

        $this->checkStorage();

        $this->secureResources();

        $this->setAssetsLink();

        $this->checkDrupal();

        $this->installNecessaryFiles();

        $this->createSymLinks();

        $this->checkAssets();

        $this->checkHorizonAssets();

        $this->checkPublicLinks();

        $this->patchVendors();

        $this->cleanCache();

        $this->checkVersion(false);

        $this->generateAppKey();

        $this->markInsideHasInstalled();

        $this->checkJwtSecretAndSetIfNeeded();

        $this->comment('[[Inside prêt]]');
    }
}
