<?php

namespace Inside\Console\Commands;

use Exception;
use Illuminate\Support\Facades\Artisan;
use Inside\Console\Command;

/**
 * Health model command.
 *
 * @category Class
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class HealCommand extends Command
{
    /**
     * @var string
     */
    protected $name = 'inside:heal';

    /**
     * @var string
     */
    protected $description = 'Perform heal actions';

    /**
     * @throws Exception
     */
    public function handle(): void
    {
        $this->info('Clear Inside Cache');
        Artisan::call('cache:clear');

        $this->info('Rebuild models');
        Artisan::call('models:rebuild');

        $this->info('Synchronize pivots');
        Artisan::call('pivots:sync');

        // new \Inside\Host\Services\DrupalService;

        // $this->info('Rebuild forms');
        // drush_invoke_process('@self', 'inside:resave-form-displays');

        // $this->info('Clean ghost contents');
        // drush_invoke_process('@self', 'inside:clean');

        // $this->info('Flush host cache');
        // drush_invoke_process('@self', 'cache:rebuild');
    }
}
