<?php

namespace Inside\Console\Commands;

use Illuminate\Support\Facades\DB;
use Inside\Console\Command;

/**
 * Class CleanupCommand
 */
class CleanupFailedJobsTable extends Command
{
    protected $name = 'inside:failed-jobs:cleanup';

    protected $signature = 'inside:failed-jobs:cleanup';

    protected $description = 'Supprime les données des jobs en échec de plus de 7 jours';

    public function handle(): void
    {
        $jobs = DB::table('failed_jobs')->where('failed_at', '<', now()->subDays(7))->delete();

        $this->info('[Failed-Jobs:Cleanup] Suppression de '.$jobs.' jobs en échec de plus de 7 jours');
    }
}
