<?php

namespace Inside\Console\Commands;

use Inside\Console\Command;

class AssetsLinkCommand extends Command
{
    protected $signature = 'assets:link';

    protected $description = 'Create a symbolic link from "public/assets" to "storage/app/assets"';

    public function handle(): void
    {
        if (file_exists(cms_base_path('assets'))) {
            $this->error('The "public/assets" directory already exists.');

            return;
        }
        $assetsDirectory = storage_path('app/assets');
        if (($storageAppPath = config('app.app_storage_path')) !== null) {
            $assetsDirectory = cms_base_path($storageAppPath.'/assets');
        }
        if (! file_exists($assetsDirectory)) {
            $this->laravel->make('files')->makeDirectory($assetsDirectory);
        }
        $this->laravel->make('files')->link(
            $assetsDirectory,
            cms_base_path('assets')
        );
        $this->info('The [public/assets] directory has been linked.');
    }
}
