<?php

namespace Inside\Console;

use Illuminate\Console\Command as BaseCommand;
use Illuminate\Support\Facades\Log;
use Symfony\Component\Console\Exception\InvalidArgumentException;

class Command extends BaseCommand
{
    public const SUCCESS = 0;

    public const FAILURE = 1;

    public const INVALID = 2;

    protected bool $logEnabled = true;

    /**  *
     * @param  string|null  $key
     * @return string|array|bool|null
     */
    public function option($key = null): string|array|bool|null
    {
        try {
            return parent::option($key);
        } catch (InvalidArgumentException $exception) {
        }

        return null;
    }

    public function line($string, $style = null, $verbosity = null): void
    {
        if ($this->logEnabled) {
            Log::info('['.$this->getName().'] '.$string);
        }
        parent::line($string, $style, $verbosity);
    }

    public function lines(array $lines, ?string $style = null, int|string|null $verbosity = null): void
    {
        foreach ($lines as $line) {
            $this->line($line, $style, $verbosity);
        }
    }

    public function warning(string $string, null|int|string $verbosity = null): void
    {
        if ($this->logEnabled) {
            Log::warning('['.$this->getName().'] '.$string);
        }
        parent::line($string, 'fg=black;bg=magenta', $verbosity);
    }

    /**
     * @param  string  $string
     * @param  int|string|null  $verbosity
     * @return void
     */
    public function info($string, $verbosity = null): void
    {
        if ($this->logEnabled) {
            Log::info('['.$this->getName().'](info) '.$string);
        }
        parent::info($string, $verbosity);
    }

    /**
     * @param  string  $string
     * @param  int|string|null  $verbosity
     * @return void
     */
    public function comment($string, $verbosity = null): void
    {
        if ($this->logEnabled) {
            Log::info('['.$this->getName().'](comment) '.$string);
        }
        parent::comment($string, $verbosity);
    }

    public function write(string $message): void
    {
        $this->output->write($message);
    }

    public function writeln(string $message): void
    {
        $this->output->writeln($message);
    }

    public function writeResult(bool $success): void
    {
        if ($success) {
            $this->writeln(' <fg=green>✔</fg=green>');

            return;
        }
        $this->writeln(' <fg=red>✘</fg=red>');
    }

    public function separatorLine(): void
    {
        $this->writeln(str_repeat('-', 80));
    }
}
