<?php

declare(strict_types=1);

namespace Inside\Content\Validation\Rules;

use Illuminate\Contracts\Validation\Rule;
use Illuminate\Contracts\Validation\Validator as ValidatorContract;
use Illuminate\Support\Facades\Validator;

final class RecursiveRules implements Rule
{
    private ?ValidatorContract $validator = null;

    public function __construct(
        private array $rules,
        private string $recursiveField,
    ) {
    }

    private function passesRules(mixed $value): bool
    {
        $this->validator = Validator::make($value, $this->rules);

        return ! $this->validator->fails();
    }

    public function passes($attribute, $value): bool
    {
        if (! $this->passesRules($value)) {
            return false;
        }

        return collect($value[$this->recursiveField] ?? [])
            ->every(fn (mixed $recursiveValue, $key) => $this->passes("$attribute.$this->recursiveField.$key", $recursiveValue));
    }

    public function message(): array | string
    {
        if ($this->validator?->errors()->any()) {
            return $this->validator->errors()->all();
        }

        return 'Recursive rules failed';
    }
}
