<?php

namespace Inside\Content\Validation\Rules;

use Illuminate\Contracts\Validation\Rule;
use Inside\Content\Facades\Schema;

final class ContentFieldExistsRule implements Rule
{
    private string $contentType;

    private string $field;

    public function __construct(
        private string $fieldName,
        private string $contentTypeFieldName = 'content_type',
    ) {
    }

    public function passes($attribute, $value): bool
    {
        if (empty($value[$this->fieldName]) || ! is_string($value[$this->fieldName])) {
            return true;
        }

        if (empty($value[$this->contentTypeFieldName]) || ! is_string($value[$this->contentTypeFieldName])) {
            return true;
        }

        $this->contentType = $value[$this->contentTypeFieldName];
        $this->field = $value[$this->fieldName];

        return Schema::hasField($this->contentType, $this->field);
    }

    public function message(): string
    {
        return "The field $this->field does not exist for content_type $this->contentType";
    }
}
