<?php

namespace Inside\Content\Validation\Rules;

use Illuminate\Contracts\Validation\Rule;
use Illuminate\Support\Facades\Lang;

/**
 * Class ContentExistsRule
 */
class ContentExistsRule implements Rule
{
    /**
     * @param string $attribute
     * @param mixed  $value
     * @return bool
     */
    public function passes($attribute, $value)
    {
        if (! is_array($value)) {
            return false;
        }

        if (! array_key_exists('uuid', $value) || ! array_key_exists('content_type', $value)) {
            return false;
        }

        $content = call_user_func(type_to_class($value['content_type']).'::find', $value['uuid']);

        if (! $content) {
            return false;
        }

        return true;
    }

    /**
     * Get the validation error message.
     *
     * @return string
     */
    public function message()
    {
        return Lang::get('validation.invalid_content');
    }
}
