<?php

namespace Inside\Content\Support;

use Hashids\Hashids;
use Inside\Content\Models\ShortUrl;

class UniqueKeyGenerator
{
    public function __construct(
        protected Hashids $hashKeyGenerator
    ) {
    }

    public function generate(): string
    {
        $uniqueId = $this->getLastInsertedID();

        do {
            $uniqueId++;
            $key = $this->hashKeyGenerator->encode($uniqueId);
        } while (ShortUrl::where('url_key', $key)->exists());

        return $key;
    }

    protected function getLastInsertedID(): int
    {
        if ($lastInserted = ShortUrl::latest()->select('id')->first()) {
            /** @var ShortUrl $lastInserted */
            return $lastInserted->id;
        }

        return 0;
    }
}
