<?php

namespace Inside\Content\Services\Traits;

use Symfony\Component\Console\Formatter\OutputFormatterStyle;
use Symfony\Component\Console\Output\ConsoleOutput;

trait HasConsole
{
    private ?ConsoleOutput $console;

    private function createConsole(): ConsoleOutput
    {
        $console = new ConsoleOutput();
        $outputStyle = new OutputFormatterStyle('white', 'green', ['bold', 'underscore']);
        $console->getFormatter()->setStyle('module', $outputStyle);
        $outputStyle = new OutputFormatterStyle('yellow', 'blue', ['bold', 'underscore']);
        $console->getFormatter()->setStyle('class', $outputStyle);
        $outputStyle = new OutputFormatterStyle('black', 'green');
        $console->getFormatter()->setStyle('success', $outputStyle);
        $outputStyle = new OutputFormatterStyle('black', 'yellow');
        $console->getFormatter()->setStyle('warning', $outputStyle);
        $outputStyle = new OutputFormatterStyle('white', 'red');
        $console->getFormatter()->setStyle('error', $outputStyle);
        $outputStyle = new OutputFormatterStyle('yellow');
        $console->getFormatter()->setStyle('note', $outputStyle);

        return $console;
    }

    public function getConsole(): ?ConsoleOutput
    {
        if (! app()->runningInConsole()) {
            return null;
        }

        return $this->console ??= $this->createConsole();
    }
}
