<?php

declare(strict_types=1);

namespace Inside\Content\Services\Revision\Widget;

use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Str;
use Inside\Content\Models\Section;

class WysiwygWidget extends TextWidget
{
    public function toFrontView(): array
    {
        $text = parent::toFrontView();
        $content = $this->content;

        if ($content instanceof Section) {
            $content = $this->root;
        }

        if (is_null($content) || $content->images->isEmpty()) {
            return $text;
        }

        foreach ($content->images as $image) {
            $disk = Storage::disk($image->disk);
            $appUrl = config('app.url');
            if (! Str::endsWith($appUrl, '/')) {
                $appUrl .= '/';
            }

            $baseUrl = str_replace($appUrl, '', $disk->url('/'));
            $text['value'] = preg_replace(
                '#'.$image->url.'#i',
                route(
                    'revision.serve',
                    [
                        'type' => class_to_type($content),
                        'uuid' => $content->uuid,
                        'version' => $this->revision->version,
                        'path' => str_replace($baseUrl, '', $image->relative_url),
                    ]
                ),
                $text['value']
            );
        }

        return $text;
    }
}
