<?php

declare(strict_types=1);

namespace Inside\Content\Services\Revision\Widget;

use Inside\Content\Models\Content;
use Inside\Content\Models\Section;
use Inside\Content\Services\Revision\RevisionService;

class SectionWidget extends AbstractWidget implements Widget
{
    public function toFrontView(): array
    {
        $data = [
            'type' => $this->options['widget'],
            'label' => $this->options['title'][$this->getLocale()] ?? '',
            'value' => [],
        ];
        foreach ($this->content->section_content as $section) {
            $data['value'][] = [
                'type' => class_to_type($section),
                'fields' => $this->revisionService->transformContentFieldsWithTransformer(
                    $section,
                    $this->revision,
                    RevisionService::TRANSFORMER_TO_FRONT_VIEW,
                    $this->content instanceof Content ? $this->content : $this->root
                ),
            ];
        }

        return $data;
    }

    public function toBridgeContentData(): mixed
    {
        $data = [];

        foreach ($this->content->section_content as $section) {
            $currentSection = call_user_func(get_class($section).'::find', $section->uuid);

            /** @var Section $section */
            $data[] = array_merge(
                [
                    'bundle' => class_to_type($section),
                    'pgID' => ! is_null($currentSection) ? $section->uuid : null,
                ],
                $this->revisionService->transformContentFieldsWithTransformer(
                    $section,
                    $this->revision,
                    RevisionService::TRANSFORMER_TO_BRIDGE_CONTENT_DATA
                )
            );
        }

        return $data;
    }
}
