<?php

declare(strict_types=1);

namespace Inside\Content\Services\Revision\Widget;

use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Str;
use Inside\Content\Models\Section;

class ImageWidget extends AbstractWidget implements Widget
{
    public function toFrontView(): array
    {
        $fieldInfo = $this->prepareFrontDataWithValue(protected_file_url($this->content, $this->fieldName));
        $content = $this->content;
        if ($content instanceof Section) {
            $content = $this->root;
        }

        if (is_null($content) || empty($fieldInfo['value'])) {
            return $fieldInfo;
        }
        $fieldInfo['value'] = preg_replace(
            '#'.$fieldInfo['value'].'#i',
            route(
                'revision.serve-file',
                [
                    'type' => class_to_type($content),
                    'uuid' => $content->uuid,
                    'version' => $this->revision->version,
                    'path' => $this->content->{$this->fieldName},
                ]
            ),
            $fieldInfo['value']
        );

        return $fieldInfo;
    }

    public function toBridgeContentData(): mixed
    {
        return $this->getValue();
    }
}
