<?php

declare(strict_types=1);

namespace Inside\Content\Services\Revision\Widget;

use Carbon\Carbon;

class DatetimeWidget extends AbstractWidget implements Widget
{
    public function toFrontView(): array
    {
        return $this->prepareFrontDataWithValue((string) $this->getValue());
    }

    public function toBridgeContentData(): mixed
    {
        $dateTime = $this->getValue();
        if (! is_int($dateTime)) {
            return null;
        }

        return get_date($dateTime)?->format('Y-m-d H:i:s');
    }
}
