<?php

namespace Inside\Content\Services;

use Inside\Content\Models\Contents\Tools;
use Inside\Host\Bridge\BridgeContent;

/**
 * Class QuickAccessService
 */
class QuickAccessService
{
    public function cleanUnpublishedTools(): void
    {
        $bridge = new BridgeContent();

        $uuidHosts = Tools::where('status', 0)
            ->get()
            ->pluck('uuid_host')
            ->toArray();

        $bridge->checkDefaultQuickAccess($uuidHosts);
    }

    public function cleanUnpublishedToolByUuid(string $uuid): void
    {
        $bridge = new BridgeContent();

        $uuidHosts = Tools::where('uuid', $uuid)
            ->get()
            ->pluck('uuid_host')
            ->toArray();

        $bridge->checkDefaultQuickAccess($uuidHosts);
    }
}
