<?php

namespace Inside\Content\Services\Queries\Traits;

use Illuminate\Database\Eloquent\Builder;

trait DateSortQuery
{
    public function sortByDate(array $value, Builder $query): bool
    {
        if (! isset($value['field'], $value['on']) || ! is_string($value['field']) || ! is_string($value['on'])) {
            return false;
        }

        $fieldName = $value['field'];

        $direction = $value['direction'] ?? 'asc';
        if (! in_array($direction, ['asc', 'desc'], true)) {
            return false;
        }

        $onValues = [
            'year',
            'month',
            'day',
            'hour',
            'minute',
            'second',
        ];

        $on = collect(explode(',', $value['on']));
        if ($on->isEmpty() || ! $on->every(fn ($value) => in_array($value, $onValues))) {
            return false;
        }

        $dateFormat = $on->map(fn (string $value) => match ($value) {
            'year' => '%Y',
            'month' => '%m',
            'day' => '%d',
            'hour' => '%H',
            'minute' => '%i',
            default => '%s'
        })->join('-');

        $query->orderByDate($fieldName, $dateFormat, $direction);

        return true;
    }
}
