<?php

declare(strict_types=1);

namespace Inside\Content\Services\Queries;

use Illuminate\Http\Request;
use Inside\Content\Contracts\ContentList as ContentListContract;
use Inside\Facades\Package;

final class ContentList implements ContentListContract
{
    public function __construct(
        protected ContentQuery $queryService
    ) {
    }

    public function __invoke(string $types, Request $request): array
    {
        $this->queryService->requestQuery($types, $request);
        $this->queryService->logAnalytic();

        if ($this->queryService->isRandom()) {
            $request['nocache'] = true;
        }

        return $this->queryService->transformCollection();
    }
}
