<?php

namespace Inside\Content\Services\Importers;

use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Str;
use Inside\Content\Models\Contents\Users;
use Inside\Host\Bridge\BridgeContent;
use Maatwebsite\Excel\Concerns\Importable;
use Maatwebsite\Excel\Concerns\OnEachRow;
use Maatwebsite\Excel\Concerns\WithChunkReading;
use Maatwebsite\Excel\Concerns\WithHeadingRow;
use Maatwebsite\Excel\Concerns\WithProgressBar;
use Maatwebsite\Excel\Row;

/**
 * Class ContentChunkedImport
 */
class ContentChunkedImport extends ContentImport implements WithChunkReading, ShouldQueue
{
    public function chunkSize(): int
    {
        return 500;
    }
}
