<?php

namespace Inside\Content\Services\ConfigurationGenerator\Traits;

use Symfony\Component\Yaml\Yaml;

trait WithOutputYaml
{
    public function getOutputYamlFilename(): string
    {
        return static::dot($this->getName(), 'yml');
    }

    public function getOutputArray(): array
    {
        return static::undot(collect($this->getBaseYaml())->merge($this->mapping())->toArray());
    }

    public function getOutputTranslationsArray(array $langcodes): array
    {
        return collect($langcodes)->mapWithKeys(fn (string $langcode) => [
            $langcode => static::undot($this->mappingTranslation($langcode)),
        ])->toArray();
    }

    public function getOutputYaml(array $yaml): ?string
    {
        if (empty($yaml)) {
            return null;
        }

        return Yaml::dump($yaml, PHP_INT_MAX, 2, Yaml::DUMP_MULTI_LINE_LITERAL_BLOCK);
    }
}
