<?php

namespace Inside\Content\Services\ConfigurationGenerator\Traits;

use Illuminate\Support\Arr;
use Illuminate\Support\Facades\File;
use Symfony\Component\Yaml\Yaml;

trait WithBaseYaml
{
    public function getBaseYamlFilename(): string
    {
        return __DIR__.'/../Yaml/'.static::dot(static::ContentEntityType, static::Bundle, 'yml');
    }

    public function getBaseYamlContent(): string
    {
        return File::get($this->getBaseYamlFilename());
    }

    public function getBaseYaml(): array
    {
        return Arr::dot(Yaml::parse($this->getBaseYamlContent()));
    }
}
