<?php

namespace Inside\Content\Services\ConfigurationGenerator;

use Illuminate\Support\Arr;
use Illuminate\Support\Facades\Lang;
use Inside\Content\Services\ConfigurationGenerator\Traits\WithDottingSyntax;

class LanguageConfiguration
{
    use WithDottingSyntax;

    protected string $main;

    protected array $others;

    protected string $default;

    protected function __construct(array $configuration)
    {
        $this->main = $configuration['main'];
        $this->default = $configuration['default'];
        $this->others = collect($configuration['all'])
            ->reject(fn ($langcode) => $langcode === $this->main)
            ->toArray();
    }

    public static function load(): self
    {
        return new self(config('generator.languages'));
    }

    public function getMain(): string
    {
        return $this->main;
    }

    public function getOthers(): array
    {
        return $this->others;
    }

    public function getDefault(): string
    {
        return $this->default;
    }

    public function from(string $key, ?string $langcode = null): string
    {
        if (is_null($langcode)) {
            $langcode = $this->getMain();
        }

        if (! str($key)->startsWith('field.')) {
            return $key;
        }

        return Lang::get($key, [], $langcode) ?? $key;
    }

    public function all(array $data, ?string $langcode = null): array
    {
        if (is_null($langcode)) {
            $langcode = $this->getMain();
        }

        $data = collect(Arr::dot($data))->map(
            fn (mixed $value) => ! is_string($value) ? $value : $this->from($value, $langcode)
        );

        return static::undot($data->toArray());
    }
}
