<?php

namespace Inside\Content\Services\ConfigurationGenerator\Bundle\Paragraphs;

use Inside\Content\Services\ConfigurationGenerator\Bundle\BaseBundle;

class ParagraphsTypeBundle extends BaseBundle
{
    public const ContentEntityType = 'paragraphs';

    public const Bundle = 'paragraphs_type';

    public const Type = 'paragraph';

    private function __construct(
        protected string $id,
        protected string $label,
    ) {
        parent::__construct();
    }

    public static function create(string $id, string $label): self
    {
        return new self($id, $label);
    }

    protected function getName(): string
    {
        return static::dot(static::ContentEntityType, static::Bundle, $this->id);
    }

    public function mapping(): array
    {
        return [
            'uuid' => $this->uuid,
            'id' => $this->id,
            'label' => static::translate()->from($this->label),
            'langcode' => static::translate()->getMain(),
        ];
    }

    public function mappingTranslation(string $langcode): array
    {
        return [
            'label' => static::translate()->from($this->label, $langcode),
        ];
    }
}
