<?php

namespace Inside\Content\Services\ConfigurationGenerator\Bundle\Language;

use Inside\Content\Services\ConfigurationGenerator\Bundle\BaseBundle;

class ContentSettingsBundle extends BaseBundle
{
    public const ContentEntityType = 'language';

    public const Bundle = 'content_settings';

    private function __construct(
        protected BaseBundle $bundle,
        protected string $id,
    ) {
        parent::__construct();
    }

    public static function create(BaseBundle $bundle, string $id): self
    {
        return new self($bundle, $id);
    }

    public function getName(): string
    {
        return static::dot(static::ContentEntityType, static::Bundle, $this->bundle::Type, $this->id);
    }

    public function mapping(): array
    {
        return [
            'uuid' => $this->uuid,
            'id' => static::dot($this->bundle::Type, $this->id),
            'target_entity_type_id' => $this->bundle::Type,
            'target_bundle' => $this->id,
            'dependencies.config' => [
                static::dot($this->bundle::ContentEntityType, $this->bundle::Bundle, $this->id),
            ],
            'langcode' => static::translate()->getMain(),
            'default_langcode' => static::translate()->getDefault(),
        ];
    }
}
