<?php

namespace Inside\Content\Services\ConfigurationGenerator\Bundle\Field\Storage;

use Illuminate\Support\Collection;
use Inside\Content\Services\ConfigurationGenerator\Bundle\BaseBundle;

class StringStorage extends BaseStorage
{
    public const Type = 'string';

    public const Module = 'core';

    public static function create(BaseBundle $bundle, string $fieldName, Collection $configuration): self
    {
        return new self(
            bundle: $bundle,
            fieldName: $fieldName,
            cardinality: $configuration->get('cardinality', static::SimpleCardinality),
            settings: array_merge([
                'max_length' => 255,
                'case_sensitive' => false,
                'is_ascii' => false,
            ], $configuration->get('storage.settings', []))
        );
    }
}
