<?php

namespace Inside\Content\Services\ConfigurationGenerator\Bundle\Field\Storage;

use Illuminate\Support\Collection;
use Inside\Content\Services\ConfigurationGenerator\Bundle\BaseBundle;

class LinkStorage extends BaseStorage
{
    public const Type = 'link';

    public const Module = 'link';

    public static function create(BaseBundle $bundle, string $fieldName, Collection $configuration): self
    {
        return new self(
            bundle: $bundle,
            fieldName: $fieldName,
            cardinality: $configuration->get('cardinality', static::SimpleCardinality),
            settings: $configuration->get('storage.settings', []),
        );
    }
}
