<?php

namespace Inside\Content\Services\ConfigurationGenerator\Bundle\Field\Storage;

use Illuminate\Support\Collection;
use Inside\Content\Services\ConfigurationGenerator\Bundle\BaseBundle;

class IntegerListStorage extends BaseStorage
{
    public const Type = 'list_integer';

    public const Module = 'options';

    public static function create(BaseBundle $bundle, string $fieldName, Collection $configuration): self
    {
        return new self(
            bundle: $bundle,
            fieldName: $fieldName,
            cardinality: $configuration->get('cardinality', static::SimpleCardinality),
            settings: $configuration->get('storage.settings', []),
        );
    }
}
