<?php

namespace Inside\Content\Services\ConfigurationGenerator\Bundle\Field\Storage;

use Illuminate\Support\Collection;
use Inside\Content\Services\ConfigurationGenerator\Bundle\BaseBundle;

class DecimalStorage extends BaseStorage
{
    public const Type = 'decimal';

    public const Module = 'core';

    public static function create(BaseBundle $bundle, string $fieldName, Collection $configuration): self
    {
        return new self(
            bundle: $bundle,
            fieldName: $fieldName,
            cardinality: $configuration->get('cardinality', static::SimpleCardinality),
            settings: array_merge([
                'precision' => 10,
                'scale' => 2,
            ], $configuration->get('storage.settings', []))
        );
    }
}
