<?php

namespace Inside\Content\Services\ConfigurationGenerator\Bundle\Field\Storage;

use Illuminate\Support\Collection;
use Inside\Content\Services\ConfigurationGenerator\Bundle\BaseBundle;

abstract class BaseStorage extends BaseBundle
{
    public const SimpleCardinality = 1;

    public const MultipleCardinality = -1;

    public const ContentEntityType = 'field';

    public const Bundle = 'storage';

    protected function __construct(
        protected BaseBundle $bundle,
        protected string $fieldName,
        protected int $cardinality,
        protected array $settings
    ) {
        parent::__construct();
    }

    abstract public static function create(BaseBundle $bundle, string $fieldName, Collection $configuration): self;

    protected function getName(): string
    {
        return static::dot(static::ContentEntityType, static::Bundle, $this->bundle::Type, $this->fieldName);
    }

    public function mapping(): array
    {
        return [
            'uuid' => $this->uuid,
            'id' => static::dot($this->bundle::Type, $this->fieldName),
            'field_name' => $this->fieldName,
            'entity_type' => $this->bundle::Type,
            'type' => static::Type,
            'settings' => static::translate()->all($this->settings),
            'module' => static::Module,
            'cardinality' => (int) $this->cardinality,
            'langcode' => static::translate()->getMain(),
            'dependencies.module' => $this->getModuleDependencies(),
        ];
    }

    public function mappingTranslation(string $langcode): array
    {
        return [
            'settings' => static::translate()->all($this->settings, $langcode),
        ];
    }

    protected function getModuleDependencies(): array
    {
        $modules = collect([$this->bundle::ContentEntityType]);

        if (static::Module !== 'core') {
            $modules->push(static::Module);
        }

        return $modules->sort()->unique()->values()->toArray();
    }
}
