<?php

namespace Inside\Content\Services\ConfigurationGenerator\Bundle\Field\Field;

use Illuminate\Support\Collection;
use Inside\Content\Services\ConfigurationGenerator\Bundle\BaseBundle;
use Inside\Content\Services\ConfigurationGenerator\Bundle\Field\Storage\ImageStorage;

class ImageField extends BaseField
{
    public const Storage = ImageStorage::class;

    public static function create(BaseBundle $bundle, string $id, string $fieldName, Collection $configuration): self
    {
        return new self(
            bundle: $bundle,
            id: $id,
            fieldName: $fieldName,
            label: $configuration->get('label'),
            description: $configuration->get('description', ''),
            required: $configuration->get('required', false),
            settings: array_merge([
                'handler' => 'default:file',
                'handler_settings' => [],
                'file_directory' => '[date:custom:Y]-[date:custom:m]',
                'file_extensions' => implode(' ', json_decode(setting('contentManagement', 'img_extensions', '[]'), true)),
                'max_filesize' => config('generator.files.max_size'),
                'max_resolution' => '',
                'min_resolution' => '',
                'alt_field' => false,
                'alt_field_required' => false,
                'title_field' => false,
                'title_field_required' => false,
                'default_image' => [
                    'uuid' => null,
                    'alt' => '',
                    'title' => '',
                    'width' => null,
                    'height' => null,
                ],
            ], $configuration->get('field.settings', [])),
            defaultValue: $configuration->get('default_value', []),
            thirdPartySettings: array_merge([
                'inside' => [
                    'special' => [
                        'image_styles' => [
                            'thumbnail' => 'thumbnail',
                            'banner_home_small' => 'banner_home_small',
                            'image_card' => 'image_card',
                            'image_grouping' => 'image_grouping',
                            'banner_page' => 'banner_page',
                            'banner_page_small' => 'banner_page_small',
                            'image_section' => 'image_section',
                            'banner_home' => 'banner_home',
                            'avatar' => 'avatar',
                        ],
                    ],
                ],
                'content_translation' => [
                    'translation_sync' => [
                        'file' => 'file',
                        'alt' => '0',
                        'title' => '0',
                    ],
                ],
            ], $configuration->get('third_party_settings', [])),
        );
    }
}
