<?php

namespace Inside\Content\Services\ConfigurationGenerator\Bundle\Field\Field;

use Illuminate\Support\Collection;
use Inside\Content\Services\ConfigurationGenerator\Bundle\BaseBundle;
use Inside\Content\Services\ConfigurationGenerator\Bundle\Field\Storage\EntityReferenceStorage;

class EntityReferenceField extends BaseField
{
    public const Storage = EntityReferenceStorage::class;

    public static function create(BaseBundle $bundle, string $id, string $fieldName, Collection $configuration): self
    {
        $dragAndDrop = collect($configuration->get('target_bundles'))
            ->map(fn ($value) => ['weight' => strlen($value), 'enabled' => true])
            ->toArray();

        return new self(
            bundle: $bundle,
            id: $id,
            fieldName: $fieldName,
            label: $configuration->get('label'),
            description: $configuration->get('description', ''),
            required: $configuration->get('required', false),
            settings: array_merge([
                'handler' => 'default:'.$configuration->get('target_type'),
                'handler_settings' => [
                    'target_bundles' => $configuration->get('target_bundles', null),
                    'negate' => 0,
                    'target_bundles_drag_drop' => $dragAndDrop,
                    'sort' => [
                        'field' => '_none',
                        'direction' => 'ASC',
                    ],
                    'auto_create' => false,
                    'auto_create_bundle' => false,
                ],
            ], $configuration->get('field.settings', [])),
            defaultValue: $configuration->get('default_value', []),
            thirdPartySettings: $configuration->get('third_party_settings', []),
        );
    }
}
