<?php

namespace Inside\Content\Services\ConfigurationGenerator\Bundle\Core;

use Illuminate\Support\Collection;
use Inside\Content\Services\ConfigurationGenerator\Bundle\BaseBundle;

class BaseFieldOverride extends BaseBundle
{
    public const ContentEntityType = 'core';

    public const Bundle = 'base_field_override';

    protected function __construct(
        protected BaseBundle $bundle,
        protected string $id,
        protected string $label,
        protected string $fieldName,
        protected string $fieldType,
        protected string $description,
        protected array $settings,
        protected array $defaultValue,
    ) {
        parent::__construct();
    }

    public static function create(BaseBundle $bundle, string $id, string $fieldName, Collection $configuration): self
    {
        return new self(
            bundle: $bundle,
            id: $id,
            label: $configuration->get('label'),
            fieldName: $fieldName,
            fieldType: $configuration->get('type'),
            description: $configuration->get('description', ''),
            settings: $configuration->get('settings', []),
            defaultValue: $configuration->get('default_value', []),
        );
    }

    protected function getName(): string
    {
        return static::dot(static::ContentEntityType, static::Bundle, $this->bundle::Type, $this->id, $this->fieldName);
    }

    public function mapping(): array
    {
        return [
            'uuid' => $this->uuid,
            'id' => static::dot($this->bundle::Type, $this->id, $this->fieldName),
            'field_name' => $this->fieldName,
            'entity_type' => $this->bundle::Type,
            'bundle' => $this->id,
            'label' => static::translate()->from($this->label),
            'description' => static::translate()->from($this->description),
            'field_type' => $this->fieldType,
            'default_value' => $this->defaultValue,
            'settings' => static::translate()->all($this->settings),
            'langcode' => static::translate()->getMain(),
            'dependencies.config' => [
                static::dot($this->bundle::ContentEntityType, $this->bundle::Bundle, $this->id),
            ],
        ];
    }

    public function mappingTranslation(string $langcode): array
    {
        return [
            'label' => static::translate()->from($this->label, $langcode),
            'description' => static::translate()->from($this->description, $langcode),
            'settings' => static::translate()->all($this->settings, $langcode),
        ];
    }
}
