<?php

namespace Inside\Content\Providers;

use Pion\Laravel\ChunkUpload\Config\AbstractConfig;
use Pion\Laravel\ChunkUpload\Config\FileConfig;
use Pion\Laravel\ChunkUpload\Providers\ChunkUploadServiceProvider as BaseChunkUploadServiceProvider;

/**
 * Chuck upload service provider. This overrides the base service provider to make it compatible with lumen.
 *
 * @category Class
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class ChunkUploadServiceProvider extends BaseChunkUploadServiceProvider
{
    public function boot(): void
    {
        $config = $this->app->make(AbstractConfig::class);

        // I didn't need the scheduler or other features they provide so I was able to go with this, as the booted methods don't exist in lumen

        $this->registerHandlers($config->handlers());
    }

    protected function registerConfig()
    {
        // Config options
        $configIndex = FileConfig::FILE_NAME;
        $configFileName = FileConfig::FILE_NAME.'.php';
        $configPath = __DIR__.'/../../config/'.$configFileName;

        // Merge the default config to prevent any crash or unfilled configs
        $this->mergeConfigFrom(
            $configPath,
            $configIndex
        );

        return $this;
    }
}
