<?php

namespace Inside\Content\Models\Traits;

use Exception;
use Illuminate\Support\Arr;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Str;
use Inside\Content\Facades\Schema;

/**
 * Trait HasSection
 *
 * Model has sections
 */
trait HasSection
{
    /**
     * Get section items for $fieldName ( which has $targets section types )
     *
     * @param  string  $fieldName
     * @return array
     * @deprecated no use
     */
    protected function getSectionTypesForField(string $fieldName): array
    {
        try {
            $fieldOptions = Schema::getFieldOptions(class_to_type($this), $fieldName);

            return $fieldOptions['target'];
        } catch (Exception $exception) {
            Log::error('['.class_to_type($this).'::getSectionTypes] failed => '.$exception->getMessage());
        }

        return [];
    }

    /**
     * Count section items for $fieldName ( which has $targets section types )
     *
     * @param  string  $fieldName
     * @param  array  $targets
     * @return int
     */
    protected function getSectionCount(string $fieldName, array $targets): int
    {
        $subQuery = [];

        foreach ($targets as $target) {
            $target = 'inside_section_'.Str::snake(str_replace('SectionItem', '', $target));
            $subQuery[] = 'SELECT COUNT('.$target.'.uuid) AS section_count FROM '.$target.' WHERE '.$target
                .'.sectionable_uuid=\''.$this->uuid.'\' AND '.$target.'.field=\''.$fieldName.'\'';
        }

        $sections = DB::select(
            DB::raw(
                'SELECT SUM(section_count) AS result FROM ('.implode(' UNION ALL ', $subQuery).') AS result'
            )
        );

        return Arr::first($sections)->result ?? 0;
    }
}
