<?php

namespace Inside\Content\Models\Traits;

use Closure;

trait CanRunWithoutEvents
{
    /**
     * Run a callback without firing events.
     *
     * @param  callable  $callback
     * @return mixed
     */
    public static function withoutEvents(callable $callback): mixed
    {
        $dispatcher = static::getEventDispatcher();
        static::unsetEventDispatcher();

        $return = $callback();

        /** @phpstan-ignore-next-line */
        if (! is_null($dispatcher)) {
            static::setEventDispatcher($dispatcher);
        }

        return $return;
    }

    /**
     * Save model without to fire related events
     *
     * @param array $options
     * @return array
     */
    public function saveQuietly(array $options = [])
    {
        return static::withoutEvents(
            function () use ($options) {
                return $this->save($options);
            }
        );
    }
}
