<?php

namespace Inside\Content\Models;

use Illuminate\Support\Collection;
use Inside\Database\Eloquent\WithEnhancedBuilder;

/**
 * @property int $id
 * @property string $destination_url
 * @property string $url_key
 * @property string $default_short_url
 * @property int $forward_query_params
 * @property string|null $created_at
 * @property string|null $updated_at
 * @property-read \Illuminate\Database\Eloquent\Collection|\Inside\Content\Models\Field[] $fields
 * @property-read int|null $fields_count
 * @property-read mixed $model
 * @method static \Inside\Database\Eloquent\Builder|ShortUrl newModelQuery()
 * @method static \Inside\Database\Eloquent\Builder|ShortUrl newQuery()
 * @method static \Inside\Database\Eloquent\Builder|ShortUrl query()
 * @method static \Illuminate\Database\Eloquent\Builder|ShortUrl whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|ShortUrl whereDefaultShortUrl($value)
 * @method static \Illuminate\Database\Eloquent\Builder|ShortUrl whereDestinationUrl($value)
 * @method static \Illuminate\Database\Eloquent\Builder|ShortUrl whereForwardQueryParams($value)
 * @method static \Illuminate\Database\Eloquent\Builder|ShortUrl whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|ShortUrl whereRedirectStatusCode($value)
 * @method static \Illuminate\Database\Eloquent\Builder|ShortUrl whereUpdatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|ShortUrl whereUrlKey($value)
 * @method static \Illuminate\Database\Query\Builder latest(string $column = 'created_at')
 * @method static ShortUrl create(array $attributes = [])
 */
class ShortUrl extends Model
{
    use WithEnhancedBuilder;

    protected $table = 'short_urls';

    protected $fillable = [
        'destination_url',
        'default_short_url',
        'url_key',
        'forward_query_params',
    ];

    protected $casts = [
        'forward_query_parameters' => 'boolean',
    ];

    public static function findByKey(string $key): ?self
    {
        return self::where('url_key', $key)->first();
    }

    public static function findByDestinationURL(string $destinationURL): Collection
    {
        return self::where('destination_url', $destinationURL)->get();
    }
}
