<?php

namespace Inside\Content\Models;

use Eloquent;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\MorphMany;
use Illuminate\Database\Eloquent\Relations\MorphTo;
use Inside\Content\Models\Traits\CanRunWithoutEvents;
use Inside\Content\Models\Traits\HasAuthor;
use Inside\Content\Models\Traits\HasSection;
use Inside\Reaction\Models\Reaction;

/**
 * Class Section
 *
 * Base Model class for all Section Models
 *
 * @property string|null $uuid
 * @property-read Collection|Reaction[] $reactions
 * @property-read int|null $reactions_count
 * @property-read Content|Section $sectionable
 * @property-read int $published_at
 * @method static \Illuminate\Database\Eloquent\Builder|Section newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|Section newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|Section query()
 */
class Section extends Model
{
    use CanRunWithoutEvents;
    use HasSection;
    use HasAuthor;

    /**
     * Relation reactions
     *
     * @return MorphMany
     */
    public function reactions(): MorphMany
    {
        return $this->morphMany(
            Reaction::class,
            'reactionable',
            'reactionable_type',
            'reactionable_uuid',
            'uuid'
        );
    }

    /**
     * @return MorphTo
     */
    public function sectionable(): MorphTo
    {
        return $this->morphTo('sectionable', 'sectionable_type', 'sectionable_uuid');
    }
}
