<?php

namespace Inside\Content\Models;

use Illuminate\Database\Eloquent\Model;

/**
 * @property string $path
 * @property string $langcode
 * @property string $title
 * @property array $json
 * @property bool $status
 *
 * @method static InsidePages findOrFail(int $id)
 * @method static InsidePages create(array $attributes = [])
 */
class InsidePages extends Model
{
    protected $table = 'inside_pages';

    protected $fillable = [
        'title',
        'json',
        'status',
        'path',
        'langcode',
    ];

    protected $casts = [
        'json' => 'array',
        'status' => 'boolean',
    ];
}
