<?php

namespace Inside\Content\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Str;
use Inside\Database\Eloquent\WithEnhancedBuilder;

/**
 * @property string $uuid
 * @property string $user_uuid
 * @property string $content_type
 * @property string $action
 * @property string|null $created_at
 *
 * @method static \Inside\Database\Eloquent\Builder|InsideLog newModelQuery()
 * @method static \Inside\Database\Eloquent\Builder|InsideLog newQuery()
 * @method static \Inside\Database\Eloquent\Builder|InsideLog query()
 * @method static \Illuminate\Database\Eloquent\Builder|InsideLog whereUuid($value)
 * @method static \Illuminate\Database\Eloquent\Builder|InsideLog whereUserUuid($value)
 * @method static \Illuminate\Database\Eloquent\Builder|InsideLog whereContentType($value)
 * @method static \Illuminate\Database\Eloquent\Builder|InsideLog whereAction($value)
 * @method static \Illuminate\Database\Eloquent\Builder|InsideLog whereCreatedAt($value)
 * @method static \Illuminate\Database\Query\Builder latest(string $column = 'created_at')
 * @method static InsideLog create(array $attributes = [])
 */
class InsideLog extends Model
{
    use WithEnhancedBuilder;

    const ACTION_DELETE = 'DELETE';

    protected $table = 'inside_logs';

    protected $primaryKey = 'uuid';

    public $incrementing = false;

    protected $keyType = 'string';

    protected $fillable = [
        'user_uuid',
        'content_type',
        'content_uuid',
        'action',
        'created_at',
    ];

    public $timestamps = false;

    protected static function boot(): void
    {
        parent::boot();

        static::creating(function ($model) {
            $model->uuid = (string) Str::uuid();
            $model->created_at = now();
        });
    }
}
